$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tutorialPadrao",
        popover: {
          title: "Padrão",
          description:
            "Aqui selecionamos se será o motivo Padrão, poderá ter apenas um motivo como padrão.",
          position: "top",
        },
      },
      {
        element: "#tutorialCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para o motivo.",
          position: "top",
        },
      },
      {
        element: "#tutorialDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição do motivo.",
          position: "top",
        },
      },
      {
        element: "#tutorialTipo",
        popover: {
          title: "Tipo",
          description:
            "Neste campo informamos o tipo do motivo.",
          position: "top",
        },
      },
      {
        element: "#tutorialObservacao",
        popover: {
          title: "Obervação",
          description:
            "Aqui adicionamos uma observação sobre este motivo.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#txtCodigo").prop("disabled", true);

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let motivo = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("MOTIVO", getCookie("usuario"), motivo);
    window.location.href = `${BASE_URI}/motivo`;
  });

  $(document).ready(function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
        txtTipo: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
        txtTipo: {
          required: "Selecione um tipo."
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#checkPadrao").on("click", async function () {
    if ($("#checkPadrao").prop("checked")) {
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN,PADRAO,DESCRICAO"], "where":[" PADRAO = 'S' "]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        if ((jsonStr.RESULT[0].length != 0) && (jsonStr.RESULT[0][0].CODMEN != motivo)){
          $("#checkPadrao").trigger("click");
          $("#checkPadrao").attr("checked", false);
          msgAlerta(`O Motivo ${jsonStr.RESULT[0][0].CODMEN} - ${jsonStr.RESULT[0][0].DESCRICAO} já está como padrão`);
        }
      } catch (error) {
        console.error(error);
      }
    }
  });

  if (motivo != "" && motivo != "create") {
    if ((await liberarRegistro("MOTIVO", motivo)) == false) {
      window.location.href = "../motivo";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"MENSAGEM", 
                    "camposSelect":["CODMEN CODIGO", "DESCRICAO", "PADRAO", "TIPO", "OBS OBSERVACAO", "ENVIA_EMAIL", "FORCA_VENDAS"], 
                    "where": ["CODMEN = '${motivo}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
          $("#txtTipo").val(jsonStr.RESULT[0][0].TIPO);
          $("#txtObs").val(jsonStr.RESULT[0][0].OBSERVACAO);

          if (jsonStr.RESULT[0][0].PADRAO == "S") {
            $("#checkPadrao").prop("checked", true);
          } else {
            $("#checkPadrao").prop("checked", false);
          }

          if (jsonStr.RESULT[0][0].ENVIA_EMAIL == "S") {
            $("#checkEmail").prop("checked", true);
          } else {
            $("#checkEmail").prop("checked", false);
          }

          if (jsonStr.RESULT[0][0].FORCA_VENDAS == "S") {
            $("#checkForcaVenda").prop("checked", true);
          } else {
            $("#checkForcaVenda").prop("checked", false);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do motivo: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let motivoClasse = {};

        motivoClasse.CODMEN =
          $("#txtCodigo").val() == ""
            ? await RetornaProximo("MENSAGEM", "MENSAGEM", "CODMEN", 6)
            : $("#txtCodigo").val();
        motivoClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        motivoClasse.TIPO = parseInt($("#txtTipo").val());
        motivoClasse.OBSERVACAO = $("#txtObs").val();

        if ($("#checkPadrao").prop("checked")) {
          motivoClasse.PADRAO = "S";
        } else {
          motivoClasse.PADRAO = "N";
        }

        if ($("#checkEmail").prop("checked")) {
          motivoClasse.ENVIAEMAIL = "S";
        } else {
          motivoClasse.ENVIAEMAIL = "N";
        }

        if ($("#checkForcaVenda").prop("checked")) {
          motivoClasse.FORCAVENDAS = "S";
        } else {
          motivoClasse.FORCAVENDAS = "N";
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/motivo?",
          `JSON=${encodeURIComponent(JSON.stringify(motivoClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(
            `Cadastro efetuado com sucesso!
                         Motivo: ${motivoClasse.CODMEN} - ${motivoClasse.DESCRICAO}`,
            "Confirmação",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 5000,
              fadeOut: 3000,
              onHidden() {
                window.location.href = `${BASE_URI}/motivo`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do motivo: ${error}`);
      }
    }
  });
});
